(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     68477,       1902]*)
(*NotebookOutlinePosition[     70203,       1955]*)
(*  CellTagsIndexPosition[     70129,       1949]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Gr\[AAcute]ficos 3D. Derivadas parciales. Gradiente", "Title"],

Cell[TextData[StyleBox[
"Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada\n\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Para empezar esta pr\[AAcute]ctica ejecuta las celdas de \
inicializaci\[OAcute]n. Lo que debes aprender en este cuaderno es lo \
sigioente.
Usar los comandos Plot3D[ ] y ParametricPlot3D[ ] con sus opciones \
principales para representar superficies y curvas en el espacio.
Usar el comando ContourPlot[ ] e interpretar su resultado.
Calcular derivadas parciales de cualquier orden de funciones de varias \
variables.
Calcular derivadas parciales de funciones compuestas.
Calcular el vector gradiente.
Calcular y representar gr\[AAcute]ficamente planos tangentes y normales en un \
punto de una superficie.
Usar el vector gradiente para calcular derivadas direccionales en un punto \
dado.\
\>", "Text"],

Cell["\<\
En la inicializaci\[OAcute]n se define un comando vector3D[ ] que puedes usar \
para representar gr\[AAcute]ficamente vectores.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\n\), 
    \(Off[ParametricPlot::ppcom]\n\), 
    \(Off[General::spell1]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(norma[x_] := N[\@\(x . x\)]\ ;  (*
      norma\ eucl\[IAcute]dea\ del\ vector\ x*) \n
    normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]];  (*
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x*) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 0}, 
          \((x[\([2]\)] \[NotEqual] 0)\) \[Or] 
            \((x[\([3]\)] \[NotEqual] 0)\), {0, x[\([3]\)], \(-x[\([2]\)]\)}, 
          \((x[\([2]\)] == 0 \[And] x[\([3]\)] == 0)\), {0, 1, 0}]]\n (*
      un\ vector\ unitario\ ortogonal\ al\ vector\ x*) \)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], grosor_:  0.007] := 
      \n\t\t\t{{color, Thickness[grosor], Line[{x, y}]}, \n
        \ \ \ \ \ {SurfaceColor[color], \ 
          \(Polygon[Append[#, y]]&\)\ /@\ \n\t\t\t\t\t\t
            Partition[
              \(\((y\ \  - \ 0.18*\((y - x)\) + \ #)\)&\)/@
                \((\((0.3*\ 0.18*norma[y - x]*\ 
                        Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                            0, 8}])\) . {normal3D[y - x], 
                      normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 1]}}; 
    \n\t\t\nvector3D[x_List: {0, 0, 0}, y_List, 
        color_:  RGBColor[0. , 0. , 0. ], grosor_:  0.007] := 
      arrow3D[x, x + y, color, grosor]\  (*
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x*) \)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Representaci\[OAcute]n gr\[AAcute]fica de superficies ", "Section"],

Cell[TextData[{
  "Para representar una superficie debes tener en primer lugar una descripci\
\[OAcute]n matem\[AAcute]tica de la misma. Las formas m\[AAcute]s frecuentes \
de dar una superficie en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " son las siguientes:\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " La superficie viene dada por ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se trata de una supercie de la forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`S = \({\((x, y, 
                z)\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : \ \((x, 
                    y)\) \[Element] A\), \ 
            z = f(x, y)} = {\((x, y, 
                f(x, y))\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : \ \
\((x, y)\) \[Element] A\)}\)\)]],
  "    donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " La superficie est\[AAcute] ",
  StyleBox["definida impl\[IAcute]citamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por una ecuaci\[OAcute]n, es decir, se trata de una superficie de la \
forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, y, 
                z)\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : 
                h(x, y, z)\) = 0}\)]],
  " "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " La superficie est\[AAcute] ",
  StyleBox["definida param\[EAcute]tricamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se trata de una superficie de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Phi](A)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\)]],
  " es una funci\[OAcute]n de dos variables con valores en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". La funci\[OAcute]n \[Phi] transforma un subconjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^\(\(2\)\(\ \)\)\
\)]],
  "en una superficie en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". En este caso se acostumbra a interpretar los puntos del conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " como par\[AAcute]metros que describen la superficie. Si notamos ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\) \[Element] A\)]],
  " un elemento gen\[EAcute]rico de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", la funci\[OAcute]n \[Phi] debe ser de la forma"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[Phi](u, 
        v) = \((\(\[Phi]\_1\)(u, v), \(\[Phi]\_2\)(u, v), \(\[Phi]\_3\)(u, 
          v))\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y, por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`S = \(\[Phi](
            A) = {\((\(\[Phi]\_1\)(u, v), \(\[Phi]\_2\)(u, v), \(\[Phi]\_3\)(
                u, v))\), \ \ \((u, v)\) \[Element] A}\)\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Nota: Oberva que ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " es un caso particular de ",
  StyleBox["b)",
    FontWeight->"Bold"],
  ". En efecto, si ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " como en a), entonces ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " tambi\[EAcute]n viene dada como en b) sin m\[AAcute]s que considerar la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`h(x, y, z) = z - f(x, y)\)]],
  ". Tambi\[EAcute]n ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " es un caso particular de",
  StyleBox[" c)",
    FontWeight->"Bold"],
  " pues basta definir para ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]]
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[Phi](x, y) = \((x, y, f(x, y))\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de comandos que permiten representar f\[AAcute]cilmente \
superficies cualquiera sea la forma en que est\[EAcute]n definidas."
}], "Text"],

Cell["\<\
Superficies que son gr\[AAcute]ficas de funciones: El comando Plot3D[ ]\
\>", "Theorem"],

Cell["\<\
La sintaxis de este comando (muy parecida a la de \"Plot[ ]\") es \
\"Plot3D[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones]\" donde se entiende que \
f[x,y] es una funci\[OAcute]n de dos variables que debe estar definida en el \
rect\[AAcute]ngulo [xmin,xmax]x[ymin,ymax]. \
\>", "Text"],

Cell[BoxData[
    \(g1 = 
      Plot3D[Sin[\@\(x\^2 + \((3 + x)\) y\^2\)], {x, \(-3\), 3}, {y, \(-4\), 
          4}, \[IndentingNewLine]PlotPoints \[Rule] 
          50, \n\t\tViewPoint \[Rule] {0.204, \(-1.212\), 
            3.153}, \[IndentingNewLine]Boxed \[Rule] 
          False, \[IndentingNewLine]Axes \[Rule] 
          None, \[IndentingNewLine]AmbientLight \[Rule] 
          GrayLevel[ .2]]\)], "Input"],

Cell[TextData[{
  "F\[AAcute]cil, \[DownQuestion]verdad?. Claro est\[AAcute], he elegido las \
opciones de \"Plot3D[ ]\" que m\[AAcute]s me gustan para representar esa \
bonita superficie. Puedes consultar las opciones en la ayuda de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Options[Plot3D]\)], "Input"],

Cell[TextData[{
  "Algunas de las opciones se entienden por s\[IAcute] solas y con un poco de \
pr\[AAcute]ctica aprender\[AAcute]s a usar las m\[AAcute]s frecuentes que \
son:\n",
  StyleBox["Mesh\[Rule]True/False",
    FontWeight->"Bold"],
  "  Indica si debe representarse o no la ret\[IAcute]cula o malla sobre la \
que se construye la gr\[AAcute]fica.\n",
  StyleBox["Shading\[Rule]True/False",
    FontWeight->"Bold"],
  "  Indica si la superficie debe ser o no ser sombreada. \n",
  StyleBox["PlotPoints\[Rule]n\.ba de puntos",
    FontWeight->"Bold"],
  "   ",
  StyleBox["Es el n\[UAcute]mero de puntos que usar\[AAcute] ",
    FontFamily->"Times New Roman"],
  StyleBox["Mathematica ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["para representar la gr\[AAcute]fica. Un n\[UAcute]mero muy alto \
producir\[AAcute] un gr\[AAcute]fico m\[AAcute]s \[OpenCurlyDoubleQuote]suave\
\[CloseCurlyDoubleQuote], pero aumentar\[AAcute], a veces de forma notable, \
el tiempo empleado para realizarlo.\n",
    FontFamily->"Times New Roman"],
  StyleBox["ViewPoint   ",
    FontFamily->"Times New Roman",
    FontWeight->"Bold"],
  StyleBox["Establece el punto de vista desde el que se dibujar\[AAcute] la \
gr\[AAcute]fica. ",
    FontFamily->"Times New Roman"],
  StyleBox["Mathematica",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[" trata de elegir siempre el punto de vista \[OAcute]ptimo. La \
forma de usar esta opci\[OAcute]n ser\[AAcute] \[OpenCurlyDoubleQuote]pegarlo\
\[CloseCurlyDoubleQuote] desde una ventana que automatiza el proceso. A dicha \
ventana se accede a trav\[EAcute]s del men\[UAcute] Input, submen\[UAcute] 3D \
ViewPoint Selector.\n",
    FontFamily->"Times New Roman"],
  StyleBox["ColorFunction\[Rule]Hue  ",
    FontFamily->"Times New Roman",
    FontWeight->"Bold"],
  StyleBox["Colorea los puntos de la gr\[AAcute]fica en funci\[OAcute]n de su \
altura sobre el plano XY. ",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[TextData[{
  "A continuaci\[OAcute]n puedes ver el efecto de cambiar algunas opciones. \
Como hemos puesto nombre a la gr\[AAcute]fica podemos representarla con \
\"Show[ ]\" y las nuevas opciones prevalecen. Observa la forma en que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa los ejes \"X\", \"Y\", \"Z\"."
}], "Text"],

Cell[BoxData[
    \(Show[g1, Mesh \[Rule] False, Boxed \[Rule] True, Axes \[Rule] True, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>", "\<z\>"}, 
      ViewPoint -> {1.300, \ \(-2.400\), \ 2.000}, 
      Ticks \[Rule] {Automatic, Automatic, {\(-1\), 1}}, 
      ColorFunction -> Hue]; \nClear[g1]\)], "Input"],

Cell[TextData[{
  "A veces hay que darle una ayudita a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para que la gr\[AAcute]fica quede bien. Por ejemplo, la siguiente gr\
\[AAcute]fica no parece lo que es: parte de un cono de revoluci\[OAcute]n \
recto de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`z = \@\(x\^2 + y\^2\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Plot3D[\@\(x\^2 + y\^2\), {x, \(-1\), 1}, {y, \(-1\), 1}, 
      AspectRatio \[Rule] 1, BoxRatios \[Rule] {1, 1, 1}, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>", "\<z\>"}, 
      PlotPoints \[Rule] 30]\)], "Input"],

Cell[TextData[{
  "Si te fijas, lo que pasa es que los bordes del cono no est\[AAcute]n a la \
misma altura sino que su altura var\[IAcute]a desde 1 a ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  ". Podemos mejorarla mucho cortando el cono con el plano ",
  Cell[BoxData[
      \(TraditionalForm\`z = 1\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(Plot3D[Min[\@\(x\^2 + y\^2\), 1], {x, \(-1\), 1}, {y, \(-1\), 1}, 
      AspectRatio \[Rule] 1, BoxRatios \[Rule] {1, 1, 1}, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>", "\<z\>"}, 
      PlotPoints \[Rule] 30]\)], "Input"],

Cell["\<\
Es muy f\[AAcute]cil hacer animaciones gr\[AAcute]ficas en 3D; basta con que \
introduzcas un par\[AAcute]metro en la funci\[OAcute]n y uses un \"Do[ ]\".  \
Aqu\[IAcute] puede ver una onda que se va desplazando producida por una gota \
que cae en el agua.\
\>", "Text"],

Cell[BoxData[{
    RowBox[{
      StyleBox[
        \(Do[Plot3D[
            Cos[\@\(x^2\  + \ y^2\) + Abs[n - 2 Pi]]/\ 
              \@\(x^2\  + \ y^2\  + \ 1/4\), 
            \ {x, \(-4\) Pi, 4 Pi}, {y, \(-4\) Pi, 4 Pi}, \ PlotPoints -> 26, 
            Lighting -> True, PlotRange -> {\(-2\), 2}, \ 
            BoxRatios -> {1, 1, 1}, Boxed -> False, Axes -> None], 
          \ {n, \ 0, \ 2 Pi\  - \ \((2 Pi/16)\), \ 2 Pi/16}]\),
        FormatType->StandardForm], 
      StyleBox[" ",
        FormatType->StandardForm], 
      StyleBox[";",
        FormatType->StandardForm], "\n", 
      \(SelectionMove[EvaluationNotebook[], All, GeneratedCell]\), ";", "\n", 
      \(FrontEndTokenExecute["\<CellGroup\>"]\)}], 
  \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell["\<\
Una manera de hacer gr\[AAcute]ficas muy interesante consiste en levantar \
cilindros sobre curvas en el plano. Por ejemplo, podemos representar en el \
plano XY la circunferencia unidad cuya ecuaci\[OAcute]n es {Cos[t],Sin[t]} \
para -\[Pi]\[LessEqual]t\[LessEqual]\[Pi], o parte de ella controlando el \
intervalo de variaci\[OAcute]n del par\[AAcute]metro \"t\", y sobre esa curva \
podemos levantar un cilidro de la altura que queramos. Claro est\[AAcute] que \
en vez de la circunferencia unidad puedes elegir cualquier otra curva cuyas \
ecuaciones param\[EAcute]tricas conozcas.\
\>", "Text"],

Cell[BoxData[
    \(\(\(fig1 = 
        ParametricPlot3D[{Cos[t], Sin[t], z}, {t, \(-\[Pi]\)/7, 
            11  \[Pi]/7}, {z, 0, 1}]\ ;\)\( (*\ 
      sobre\ una\ parte\ de\ la\ circunferencia\ unidad\ levantamos\ un\ \
cilindro\ de\ altura\ 1\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Antes de ejecutar la siguiente celda piensa medio minuto (no quiero que te \
canses...) si ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " podr\[AAcute] hacer lo que le pedimos. Se trata de representar la mitad \
superior de la esfera unidad."
}], "Text"],

Cell[BoxData[
    \(\(Plot3D[\@\(1 - x\^2 - y\^2\), {x, \(-1\), 1}, {y, \(-1\), 1}, 
        PlotPoints \[Rule] 50, AspectRatio \[Rule] 1, 
        Axes \[Rule] None];\)\)], "Input"],

Cell["\<\
Ya ves lo que ha pasado: nuestra funci\[OAcute]n no toma valores reales en \
todos los puntos del rect\[AAcute]ngulo [-1,1]x[-1,1]. Hay muchas formas de \
arreglar esto. Por ejemplo tomando parte real con el comando \"Re [ ]\".\
\>", "Text"],

Cell[BoxData[
    \(\(Plot3D[Re[\@\(1 - x\^2 - y\^2\)], {x, \(-1\), 1}, {y, \(-1\), 1}, 
        PlotPoints \[Rule] 50, AspectRatio \[Rule] 1, 
        Axes \[Rule] None];\)\)], "Input"],

Cell["\<\
Pero si quieres representar la esfera completa el comand \"Plot3D[ ]\" no es \
el m\[AAcute]s apropiado.\
\>", "Text"],

Cell["\<\
Curvas y superficies dadas por ecuaciones param\[EAcute]tricas: El comando \
ParametricPlot3D[ ]\
\>", "Theorem"],

Cell["\<\
La sintaxis de este comando (muy parecida a la de \"ParametricPlot[ ]\") es 
\t\t\t\"ParametricPlot3D[{X[u,v], Y[u,v], Z[u,v]},{u, umin, umax},{v, vmin, \
vmax},opciones]\" 
donde se entiende que X, Y, Z son funciones de dos variables que deben estar \
definidas en el rect\[AAcute]ngulo [umin, umax]x[ymin, ymax]. Para usar este \
comando lo \[UAcute]nico que necesitas es conocer las ecuaciones param\
\[EAcute]tricas de la superficie. Aqu\[IAcute] tienes una esfera.\
\>", "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Sin[\[Phi]] Cos[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], 
          Cos[\[Phi]]}, {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Phi], 
          0, \[Pi]}];\)\)], "Input"],

Cell["\<\
Controlando los par\[AAcute]metros puedes conseguir representar partes de la \
superficie. \
\>", "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Sin[\[Phi]] Cos[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], Cos[\[Phi]]}, {\[Theta], 0, 
          3  \[Pi]/2}, {\[Phi], \[Pi]/8, \[Pi]}];\)\)], "Input"],

Cell[TextData[{
  "El comando \"ParametricPlot3D[{f[x] Cos[t], f[x] Sin[t], x},{x,a,b},{t,0,2\
\[Pi]}]\"  representa la gr\[AAcute]fica de la superficie de \
revoluci\[OAcute]n obtenida girando la curva de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  " alrededor del segmento [a,b] del eje OZ. Por ejemplo, la esfera anterior \
puedes representarla como sigue"
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{\(\@\(1 - x\^2\)\) Cos[t], \(\@\(1 - x\^2\)\) 
            Sin[t], x}, {x, \(-1\), 1}, {t, \(-\[Pi]\), \[Pi]}];\)\)], "Input"],

Cell[TextData[{
  "El comando ParametricPlot3D[{X[t],Y[t],Z[t]},{t,tmin,tmax},opciones] sirve \
para representar curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " dadas por sus ecuaciones param\[EAcute]tricas. Si a\[NTilde]ades al final \
una funci\[OAcute]n de color, como en el siguiente ejemplo donde se usa la \
funci\[OAcute]n de color \"Hue[ ]\", los puntos de la curva se colorean \
variando los colores de forma continua."
}], "Text"],

Cell[BoxData[
    \(\(\(ParametricPlot3D[{3  Cos[t], 3  Sin[t], t, Hue[t]}, {t, 0, 
        4  \[Pi]}]\)\(;\)\( (*\ 
      una\ h\[EAcute]lice\ circular\ *) \)\)\)], "Input"],

Cell["Tambi\[EAcute]n puedes controlar directamente el grosor de la \
l\[IAcute]nea.", "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{3  Cos[t], 6  Sin[t], 
        t, {Hue[t], Thickness[0.02]}}, {t, 0, 4  \[Pi]}]; \)\)], "Input"],

Cell["Curvas de nivel: el comando ContourPlot[ ]", "Theorem"],

Cell[TextData[{
  "Una forma interesante de ver la gr\[AAcute]fica de una funci\[OAcute]n es \
mediante curvas de nivel. Por este m\[EAcute]todo lo que se hace es \
representar la gr\[AAcute]fica de una funci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " proyectando sobre el plano XY las curvas intersecci\[OAcute]n de dicha \
superficie con planos paralelos al plano XY (curvas de nivel). Est\[AAcute]s \
acostumbrado a ver estas representaciones porque los mapas \
topogr\[AAcute]ficos representan el relieve del terreno por curvas de nivel. \
Esta representaci\[OAcute]n permite ver las zonas donde la funci\[OAcute]n \
var\[IAcute]a m\[AAcute]s r\[AAcute]pidamente porque las curvas de nivel est\
\[AAcute]n m\[AAcute]s pr\[OAcute]ximas entre s\[IAcute]. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa con tonos m\[AAcute]s luminosos las zonas donde la funci\
\[OAcute]n toma valores m\[AAcute]s grandes y con tonos m\[AAcute]s oscuros \
las zonas donde la funci\[OAcute]n es m\[AAcute]s peque\[NTilde]a. En el \
siguiente ejemplo muestra claramente lo que se hace (observa, de paso, el uso \
de la primitiva gr\[AAcute]fica \"Polygon[ ]\" en 3D)."
}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(graph1\  = 
      Plot3D[\((3  x\^2 + y\^2)\) Exp[1 - x\^2 - y\^2], {x, \(-2\), 2}, {y, 
          \(-2\), 2}, PlotPoints -> 30\ , DisplayFunction -> Identity]; \n
    Plane[h_, size_] := \n\t
      Graphics3D[{
          Polygon[{{\(-size\), \(-size\), h}, {size, \(-size\), h}, {size, 
                size, h}, {\(-size\), size, h}}]}]\), 
    \(graph2 = Show[{graph1, Plane[1.6, 2]}, \ DisplayFunction -> Identity]; 
    \nShow[GraphicsArray[{graph1, graph2}], 
      DisplayFunction -> $DisplayFunction\ ]; \nClear[grap1, graph2]\)}], 
  "Input"],

Cell[TextData[{
  "Como puedes ver, \"ContourPlot[ ]\" nos va a proporcionar un \"mapa topogr\
\[AAcute]fico\" de la funci\[OAcute]n. Las l\[IAcute]neas de contorno unen \
los puntos de la superficie que tienen la misma altura. Por defecto, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa curvas de contorno para una sucesi\[OAcute]n de valores de \
altura igualmente espaciados. La sintaxis del comando es"
}], "Text"],

Cell["\"ContourPlot[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones]\"", "Text",
  TextAlignment->Center],

Cell["\<\
Las opciones son las mismas del comando \"ContourGraphics[ ]\" que sirve para \
representar varios \"ContourPlot[ ]\" y, adem\[AAcute]s, puede controlarse el \
n\[UAcute]mero de puntos de evaluaci\[OAcute]n con PlotPoints\[Rule]n\.ba de \
puntos. Veamos el gr\[AAcute]fico de contorno de la superficie anterior.\
\>", "Text"],

Cell[BoxData[
    \(\(ContourPlot[
      \((3  x\^2 + y\^2)\) Exp[1 - x\^2 - y\^2], {x, \(-2\), 2}, {y, \(-2\), 
        2}]; \)\)], "Input"],

Cell["\<\
Puedes observar claramente dos cumbres (dos m\[AAcute]ximos) y un pozo (un m\
\[IAcute]nimo). Las opciones son muchas. \
\>", "Text"],

Cell[BoxData[
    \(Options[ContourGraphics]\)], "Input"],

Cell["\<\
El comando \"DensityPlot[f[x,y],{x,xmin,xmx},{y,ymin,ymax},opciones]\", \
parecido al anterior, representa los valores de la funci\[OAcute]n sobre una \
ret\[IAcute]cula en el plano. Lo que hace es dividir el rect\[AAcute]ngulo \
[xmin,xmax]x[ymin,ymax] en 15x15=225 retangulitos y evaluar en el centro de \
cada uno de ellos la funci\[OAcute]n. Los tonos m\[AAcute]s luminosos se \
corresponden con los valores mayores de la funci\[OAcute]n. Con este comando \
se pueden hacer gr\[AAcute]ficas muy hermosas.\
\>", "Text"],

Cell[BoxData[
    \(\(\(DensityPlot[Sin[1/\((x*y)\)], {x, \(-2\), 2}, {y, \(-2\), 2}, 
      PlotPoints -> 200, ColorFunction -> Hue, Mesh -> False]; 
    \) (*\ si\ aumentas\ el\ n\[UAcute]mero\ de\ puntos\ queda\ mejor\ pero\ 
        tarda\ m\[AAcute]s\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Representa gr\[AAcute]ficamente la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = sen(exp(x + y))\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\) \[LessEqual] x \[LessEqual] 
        2, \ \(-3\) \[LessEqual] y \[LessEqual] 3\)]],
  ". Explica si la gr\[AAcute]fica obtenida te parece una representaci\
\[OAcute]n fiel de la funci\[OAcute]n.\nb) Compara la gr\[AAcute]fica \
anterior con la de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](x, y) = sen(exp(x + y)) + 6  x\ y\)]],
  " en los mismos intervalos. Explica lo que ha ocurrido con las monta\
\[NTilde]as y valles de la primera gr\[AAcute]fica.\nc) Elije distintos \
intervalos para las variables, diferentes puntos de vista y resoluciones \
hasta que logres una representaci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y)\)]],
  " que te parezca que refleja apropiadamente el comportamiento de la funci\
\[OAcute]n.\nd) Representa distintas curvas de nivel para obtener m\[AAcute]s \
informaci\[OAcute]n sobre la funci\[OAcute]n.\ne) Considera las \
gr\[AAcute]ficas de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y) = cos(x\ y)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\) \[Pi] \[LessEqual] x, 
      y \[LessEqual] 3  \[Pi]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(h(x, y)\)\(=\)\(cos(exp(x\ y))\)\(\ \)\)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\(-6\) \[LessEqual] 
        x, \(\(y\)\(\[LessEqual]\)\(6\)\(\ \)\)\)]],
  "y procede con cada una de ellas de forma an\[AAcute]loga a como lo has \
hecho con la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "a) Considera la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(\(x\^2\) y\)\/\(x\^4 + y\^2\)\)]],
  " en el intervalo -0.0001\[LessEqual]x\[LessEqual]0.0001, 0\[LessEqual]y\
\[LessEqual]0.00001. Indica por qu\[EAcute] esta gr\[AAcute]fica es enga\
\[NTilde]osa y no representa fielmente a la funci\[OAcute]n. Trata de \
representar la gr\[AAcute]fica de forma que se aprecie claramente que la \
funci\[OAcute]n es discontinua en el origen (se supone que ",
  Cell[BoxData[
      \(TraditionalForm\`f(0, 0) = 0\)]],
  "). Para obtener mayor informaci\[OAcute]n del comportamiento de la func\
\[OAcute]n representa gr\[AAcute]ficos de nivel. \nb) Representa en el plano \
las curvas de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x, \[Lambda]\ x)\)]],
  " para distintos valores de \[Lambda]\[NotEqual]0 y comprueba \
gr\[AAcute]ficamente que son continuas en el origen. "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Haz una animaci\[OAcute]n gr\[AAcute]fica para representar la evoluci\
\[OAcute]n de la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(cos(x\ t)\) \(sen(y\ t)\)\)]],
  " cuando el par\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " toma distintos valores. Elije las opciones apropiadas para optimizar la \
representaci\[OAcute]n."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivadas parciales", "Section"],

Cell[TextData[{
  "Para campos escalares de varias variables (esto es, funciones que \
\"salen'' de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " y \"llegan'' a \[DoubleStruckCapitalR]), el comando \
\"D[f[x,y,...],{x,n1},{y,n2},...]}\" nos devuelve la derivada parcial de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " n1-veces, respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " n2-veces,... pudiendo omitirse el n\[UAcute]mero de veces si \[EAcute]ste \
es 1. Si se omite una variable quiere decir que no se deriva respecto de ella \
ninguna vez. "
}], "Text"],

Cell[BoxData[
    \(\(\(D[
        x\^y + Sin[x*y], {x, 3}, {y, 
          2}]\)\(//\)\(Simplify\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce la regla de la cadena para derivadas parciales. Observa \
c\[OAcute]mo eval\[UAcute]a correctamente las derivadas parciales de una \
funci\[OAcute]n compuesta. Tambi\[EAcute]n debes fijarte en la forma en que \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa las derivadas parciales."
}], "Text"],

Cell[BoxData[{
    \(f[u_, v_] = g[u\^2 + v\^2, Cos[u*v]]; 
    \  (*f[u, v]\ es\ la\ funci\[OAcute]n\ compuesta\ g[x, y]\ con\ x = 
        u\^2 + v\^2, \ y = Cos[u*v]*) \nD[f[u, v], u]\), 
    \(D[f[u, v], u] /. {u -> 1, v -> \[Pi]/2}\)}], "Input"],

Cell["\<\
Para definir una funci\[OAcute]n derivada parcial hay que tomar ciertas \
precauciones. En particular, no es aconsejable usar la asignaci\[OAcute]n \
diferida. \
\>", "Text"],

Cell[BoxData[{
    \(f[x_, y_] := Sin[x*y]; \nfx3[x_, y_] := D[f[x, y], {x, 3}]\), 
    \(fx3[1, 2]\)}], "Input"],

Cell[TextData[{
  "Al definir fx3[x,y] con una igualdad diferida (:=) lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha almacenado como definici\[OAcute]n de fx3[x,y] ",
  StyleBox["no",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es la derivada parcial de f[x,y] respecto a la variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " tres veces, sino el comando ",
  Cell[BoxData[
      \(TraditionalForm\`"D[f[x,y], {x, 3}]"\)]],
  "; pero dicho comando ",
  StyleBox["no se ha ejecutado",
    FontSlant->"Italic"],
  " pues se trata de una ",
  StyleBox["asignaci\[OAcute]n diferida",
    FontSlant->"Italic"],
  " por lo que dicho comando se ejecuta ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de que se llame a la funci\[OAcute]n fx3[x,y]. Por eso cuando escribes \
fx3[1,2] lo que est\[AAcute]s diciendo a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es que derive f[1,2] respecto a la variable 1 tres veces y, claro est\
\[AAcute], 1 no es una variable v\[AAcute]lida para derivar. Naturalmente, \
esto se arregla definiendo fx3[x,y] con la asignaci\[OAcute]n inmediata (=)."
}], "Text"],

Cell[BoxData[{
    \(Clear[fx3]\), 
    \(fx3[x_, y_] = D[f[x, y], {x, 3}]; \nfx3[1, 2]\)}], "Input"],

Cell["\<\
La forma m\[AAcute]s segura de definir una derivada parcial es localizar la \
variable respecto de la que se deriva y sustituir despu\[EAcute]s por la \
variable en cuesti\[OAcute]n. Haci\[EAcute]ndolo de esta forma se puede usar \
la asignaci\[OAcute]n diferida.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[fx3]\), 
    \(fx[x_, y_] := Module[{s}, D[f[s, y], {s, 3}] /. s -> x]\), 
    \(fx[1, 2]\), 
    \(Clear[f, fx]\)}], "Input"],

Cell["\<\
Para calcular el gradiente de una funci\[OAcute]n de varias variables basta \
construir el vector formado por las derivadas parciales primeras de la funci\
\[OAcute]n respecto de todas las variables.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\(grad[f_]\)[x_, y_] = {D[f[x, y], x], D[f[x, y], y]}; 
    \)\n (*tambi\[EAcute]n\ puedes\ definirlo\ usando\ la\ asignaci\[OAcute]n
          \ diferida\ de\ la\ forma\n\t\t\(grad[f_]\)[x_, y_] := 
        Module[{s, t}, \ {D[f[s, y], s] /. s -> x, D[f[x, t], t] /. t -> y}]
          \ *) \)\)], "Input"],

Cell[BoxData[{
    \(f[x_, y_] := x^2*Cos[y*x]; \n\(grad[f]\)[1, 2]\), 
    \(Clear[f]\)}], "Input"],

Cell[TextData[{
  "La matriz hessiana se obtiene como sigue (observa, de paso c\[OAcute]mo \
representa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las derivadas parciales)."
}], "Text"],

Cell[BoxData[
    \(\(H[f_]\)[x_, 
        y_] = {{D[f[x, y], {x, 2}], D[f[x, y], x, y]}, {D[f[x, y], x, y], 
          D[f[x, y], {y, 2}]}}\)], "Input"],

Cell["\<\
Si prefieres verla en forma de matriz puedes hacerlo como sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(H[f]\)[x, y] // MatrixForm\)], "Input"],

Cell[TextData[{
  "Para una funci\[OAcute]n de tres variables podemos construir \
c\[OAcute]modamente su matriz hessiana con la ayuda del comando \"Outer[ ]\". \
Si ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " es una funci\[OAcute]n, pongamos de 2 variables, y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = {a, b, c, d}, \ \[Beta] = {u, v, w}\)]],
  " son listas, el comando"
}], "Text"],

Cell[TextData["Outer[h,\[Alpha],\[Beta]]"], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "proporciona una matriz de orden 4x3 cuyos elementos son ",
  Cell[BoxData[
      \(TraditionalForm\`h[\[Alpha][\([i]\)], \[Beta][\([j]\)]]\)]],
  ". Si aplicamos el comando \"Outer[ ]\" al operador diferencial D, al \
vector gradiente de una funci\[OAcute]n y a las variables de dicha funci\
\[OAcute]n, obtenemos la matriz hessiana."
}], "Text"],

Cell[BoxData[{
    \(\(grad3[f_]\)[x_, y_, z_] = {D[f[x, y, z], x], D[f[x, y, z], y], 
        D[f[x, y, z], z]}; \n
    \(H3[f_]\)[x_, y_, z_] = Outer[D, \(grad3[f]\)[x, y, z], {x, y, z}]\), 
    \(\(H3[f]\)[x, y, z] // MatrixForm\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = log(1 + x\^2 + 2  x + y\^2)\)]],
  ". \na) Calcula el gradiente y la matriz hessiana de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ".\nb) Comprueba que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]\^2\ f\/\[PartialD]\ x\^2\) \((x, y)\) + 
          \(\[PartialD]\^2\ f\/\[PartialD]\ y\^2\) \((x, y)\) = 0\)]],
  " (la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\ \)\)]],
  "es arm\[OAcute]nica)"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "a) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`z = x\ \(f(x, y)\) + y\ \(g(x + y)\)\)]],
  ". Comprueba que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[PartialD]\^2\ z\/\[PartialD]\ x\^2\) \((x, y)\) + 
          \(\[PartialD]\^2\ z\/\[PartialD]\ y\^2\) \((x, y)\) - 
          2\ \(\[PartialD]\^2\ z\/\(\[PartialD]\ x \[PartialD]\ y\)\) 
            \((x, y)\) = 0\)]],
  "."
}], "ExerciseText"],

Cell[TextData[{
  "b) Comprueba que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`2  ArcTan[y\/\(x + \@\(x\^2 + y\^2\)\)]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[y\/x]\)]],
  " tienen las mismas derivadas parciales.\nc) Define ",
  Cell[BoxData[
      \(TraditionalForm
      \`g[\[Rho], \[Theta]] = 
        f[\[Rho]\ Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y)\)]],
  " es una funci\[OAcute]n de dos variables que no se supone conocida. Se \
dice que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " es la expresi\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en coordenadas polares. Calcula las derivadas parciales de primer orden \
de ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Rho], \[Theta])\)]],
  " .\nd) Calcula las derivadas parciales de primer orden de la \
funci\[OAcute]n"
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm
    \`F(x, y) = 
      \[Integral]\_\(x\ y\ \)\%\(f(x, y)\)\(h(t)\) \[DifferentialD]t\)], 
  "Text",
  TextAlignment->Center]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plano tangente en un punto de una superficie", "Section"],

Cell[TextData[{
  "Se dice que un vector ",
  Cell[BoxData[
      \(TraditionalForm\`w \[Element] \[DoubleStruckCapitalR]\^3\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es tangente a una superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) \[Element] S\)]],
  " si se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " es el vector tangente en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " a una curva contenida en ",
  StyleBox["S",
    FontSlant->"Italic"],
  " y que pasa por dicho punto. Se dice que un vector ",
  Cell[BoxData[
      \(TraditionalForm\`w \[Element] \[DoubleStruckCapitalR]\^3\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a una superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) \[Element] S\)]],
  " si se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " es ortogonal a todo vector tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". \nSe verifica que el plano tangente a la superficie en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " contiene a todos los vectores tangentes a la superficie en dicho punto. \
El c\[AAcute]lculo del plano tangente depende de c\[OAcute]mo venga dada la \
superficie. Consideremos los tres casos posibles."
}], "Text"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  ") Supongamos que la superficie viene dada por ecuaciones \
param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  " y"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](s, t)\), "=", 
        RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
          RowBox[{
            RowBox[{\(x(s, t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(y(s, t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(s, t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para calcular el plano tangente en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Gamma]", "(", 
            FormBox[
              RowBox[{
                FormBox[\(s\_0\),
                  "TraditionalForm"], ",", \(t\_0\)}],
              "TraditionalForm"], ")"}], 
          "=", \(\((a, b, c)\) \[Element] \ S\)}], TraditionalForm]]],
  ", basta darse cuenta de que las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha](s) = \[Gamma](s, t\_0)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta](t) = \[Gamma](s\_0, t)\)]],
  " est\[AAcute]n contenidas en ",
  StyleBox["S",
    FontSlant->"Italic"],
  " y pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". Los vectores tangentes a dichas curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " vienen dados por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Alpha]' \((s\_0)\)\), "=", 
        RowBox[{
          FormBox[
            RowBox[{\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\), 
              RowBox[{"(", 
                FormBox[
                  RowBox[{
                    FormBox[\(s\_0\),
                      "TraditionalForm"], ",", \(t\_0\)}],
                  "TraditionalForm"], ")"}]}],
            "TraditionalForm"], "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ x\/\[PartialD]\ s\), 
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}]}],
                  "TraditionalForm"], ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\(\[PartialD]\ y\/\[PartialD]\ s\), 
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}]}], ","}],
                    "TraditionalForm"], 
                  FormBox[
                    RowBox[{\(\[PartialD]\ z\/\[PartialD]\ s\), 
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}]}],
                    "TraditionalForm"]}]}], ")"}], "=", 
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ x\/\[PartialD]\ s\), 
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}]}],
                  "TraditionalForm"], 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox["+",
                FontWeight->"Plain"], 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ y\/\[PartialD]\ s\), 
                    FormBox[
                      RowBox[{
                        RowBox[{
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{
                                FormBox[\(s\_0\),
                                  "TraditionalForm"], ",", \(t\_0\)}],
                              "TraditionalForm"], ")"}], 
                          StyleBox["j",
                            FontWeight->"Bold"]}], "+"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"], 
                FormBox[
                  RowBox[{\(\[PartialD]\ z\/\[PartialD]\ s\), 
                    FormBox[
                      RowBox[{
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}], 
                        StyleBox["k",
                          FontWeight->"Bold"]}],
                      "TraditionalForm"]}],
                  "TraditionalForm"]}]}]}]}]}], TraditionalForm]], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Beta]\ ' \((t\_0)\)\), "=", 
        RowBox[{
          FormBox[
            RowBox[{\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\), 
              RowBox[{"(", 
                FormBox[
                  RowBox[{
                    FormBox[\(s\_0\),
                      "TraditionalForm"], ",", \(t\_0\)}],
                  "TraditionalForm"], ")"}]}],
            "TraditionalForm"], "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{\(\[PartialD]\ x\/\[PartialD]\ t\), 
                      FormBox[
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}],
                        "TraditionalForm"]}],
                    "TraditionalForm"], 
                  FormBox[
                    RowBox[{",", 
                      RowBox[{\(\[PartialD]\ y\/\[PartialD]\ t\), 
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox[\(s\_0\),
                                "TraditionalForm"], ",", \(t\_0\)}],
                            "TraditionalForm"], ")"}]}]}],
                    "TraditionalForm"]}], ",", 
                FormBox[
                  RowBox[{\(\[PartialD]\ z\/\[PartialD]\ t\), 
                    FormBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"]}], ")"}], "=", 
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ x\/\[PartialD]\ t\), 
                    FormBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"], 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], " ", "+", 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ y\/\[PartialD]\ t\), 
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}]}],
                  "TraditionalForm"], " ", 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], " ", "+", 
              RowBox[{
                FormBox[
                  RowBox[{\(\[PartialD]\ z\/\[PartialD]\ t\), 
                    FormBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox[\(s\_0\),
                              "TraditionalForm"], ",", \(t\_0\)}],
                          "TraditionalForm"], ")"}],
                      "TraditionalForm"]}],
                  "TraditionalForm"], 
                StyleBox["k",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}]}]}], TraditionalForm]], "Text"],

Cell[TextData[{
  "que son los vectores columna de la matriz jacobiana de \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`\((s\_0, t\_0)\)\)]],
  ". S",
  StyleBox["e supone que dichos vectores son linealmente independientes pues \
en otro caso el plano tangente a ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  StyleBox[" en ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((a, b, c)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" no est\[AAcute] definido",
    FontWeight->"Bold"],
  ". El plano tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " es la traslaci\[OAcute]n a dicho punto del plano vectorial engendrado por \
estos dos vectores. En consecuencia, el plano tangente tiene las ecuaciones \
param\[EAcute]tricas siguientes:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{\((x, y, z)\), "=", 
          RowBox[{
            RowBox[{"\[Gamma]", "(", 
              FormBox[
                RowBox[{
                  FormBox[\(s\_0\),
                    "TraditionalForm"], ",", \(t\_0\)}],
                "TraditionalForm"], ")"}], "+", 
            RowBox[{"s", 
              FormBox[
                RowBox[{\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\), 
                  FormBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox[\(s\_0\),
                            "TraditionalForm"], ",", \(t\_0\)}],
                        "TraditionalForm"], ")"}],
                    "TraditionalForm"]}],
                "TraditionalForm"]}], " ", "+", " ", 
            RowBox[{"t", " ", \(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\), 
              FormBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox[\(s\_0\),
                        "TraditionalForm"], ",", \(t\_0\)}],
                    "TraditionalForm"], ")"}],
                "TraditionalForm"], 
              "                              ", \((s, 
                t \[Element] \[DoubleStruckCapitalR])\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["2)",
    FontWeight->"Bold"],
  " Supongamos que la superficie est\[AAcute] ",
  StyleBox["definida impl\[IAcute]citamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por una ecuaci\[OAcute]n, es decir, se trata de una superficie de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, y, 
                z)\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : 
                g(x, y, z)\) = 0}\)]],
  " donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es un campo escalar de tres variables. Para calcular el plano tangente a \
",
  StyleBox["S",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\) \[Element] S\)]],
  ", basta observar que el vector gradiente de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " calculado en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " es ortogonal a todo vector tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". Ello es consecuencia de que si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^3\)]],
  " es una curva contenida en la superficie ",
  StyleBox["S",
    FontSlant->"Italic"],
  " que pasa por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha](t\_0) = \((a, b, c)\)\)]],
  ", entonces se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Alpha](t)) = 0\)]],
  " para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(t \[Element] \([a, b]\)\)\)\)]],
  ", por lo que la derivada de la funci\[OAcute]n compuesta ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Alpha](t))\)]],
  " es id\[EAcute]nticamente nula, es decir ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(\[Alpha](
                  t))\) | \[Alpha]' \((t)\)\[RightAngleBracket] = 0\)]],
  " para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(t \[Element] \([a, b]\)\)\)\)]],
  ", en particular, para ",
  Cell[BoxData[
      \(TraditionalForm\`t = t\_0\)]],
  " obtenemos que \[LeftAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b, c)\) | \[Alpha]' \((t\_0)\)\)]],
  "\[RightAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm\`\(\(=\)\(0\)\)\)]],
  ". Deducimos que el plano tangente a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  " es el plano que tiene como vector ortogonal ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b, c)\)\)]],
  " y que pasa por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ". ",
  StyleBox["Se supone que ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Del]\(g(a, b, c)\) \[NotEqual] \ \((0, 0, 0)\)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" pues en otro caso, el plano tangente en ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((a, b, c)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" no est\[AAcute] definido.",
    FontWeight->"Bold"],
  " En consecuencia, el plano tangente es el plano de ecuaci\[OAcute]n \
cartesiana"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(a, b, c)\) | \((x - a, 
            y - b, z - c)\)\[RightAngleBracket] = 0\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["3)",
    FontWeight->"Bold"],
  " Si la superficie es la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, y, 
              f(x, y))\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : \ \
\((x, y)\) \[Element] A\)}\)]],
  " donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables, entonces dicha superficie est\
\[AAcute] definida impl\[IAcute]tamente por la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y, z) = \(f(x, y) - z = 0\)\)]],
  ". Como consecuencia de lo visto en el punto anterior, el plano tangente en \
un punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\((a, b, 
          c)\) = \((a, b, f(a, b))\) \[Element] S\)\)\)]],
  " es el plano de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(a, b, c)\) | \((x - a, 
              y - b, z - f(a, b))\)\[RightAngleBracket] = 0\)]],
  " y, como, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(g(a, b, c)\)\), "=", 
          
          FormBox[\(\((\(\[PartialD]\ f\/\[PartialD]\ x\) \((a, 
                  b)\), \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, 
                  b)\), \(-1\))\)\(\ \)\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", se sigue que la ecuaci\[OAcute]n del plano tangente es ",
  Cell[BoxData[
      \(TraditionalForm\`z - 
          c = \(\[PartialD]\ f\/\[PartialD]\ x\) \((a, 
              b)\) \((x - a)\) + \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, 
              b)\) \((y - b)\)\)]],
  ".\nObserva que ",
  StyleBox["S ",
    FontSlant->"Italic"],
  "tiene como ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x, y) = \((x, y, f(x, y))\)\)]],
  " por lo que los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 
        0, \(\[PartialD]\ f\/\[PartialD]\ x\) \((a, b)\))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 
        1, \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, b)\))\)\)]],
  " son tangentes a ",
  StyleBox["S",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  ".  El vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(\[PartialD]\ f\/\[PartialD]\ x\) \((a, 
            b)\), \(\[PartialD]\ f\/\[PartialD]\ y\) \((a, 
            b)\), \(-1\))\)\)]],
  " es ortogonal a dichos vectores, como debe ser seg\[UAcute]n lo dicho en \
el punto anterior."
}], "Text"],

Cell["La siguiente gr\[AAcute]fica ilustra estos conceptos.", "Text"],

Cell[BoxData[
    \(\[Gamma][\[Theta]_, \[Phi]_] = {Cos[\[Phi]] Sin[\[Theta]], 
        Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]]}; \na = N[\[Pi]/3]; 
    b = \(-N[\[Pi]/10]\); \np = \[Gamma][a, b]; \n
    v1 = D[\[Gamma][\[Theta], \[Phi]], \[Theta]] /. {\[Theta] -> a, 
          \[Phi] -> b}; \n
    v2 = D[\[Gamma][\[Theta], \[Phi]], \[Phi]] /. {\[Theta] -> a, 
          \[Phi] -> b}; \n
    curva1 = ParametricPlot3D[\[Gamma][a, \[Phi]], {\[Phi], 0, 2  \[Pi]}, 
          DisplayFunction \[Rule] Identity] /. \ 
        Line[x_] \[Rule] {Hue[0], Thickness[ .01], Line[x]}; \n
    curva2 = ParametricPlot3D[\[Gamma][\[Theta], b], {\[Theta], 0, \[Pi]}, 
          DisplayFunction \[Rule] Identity] /. \ 
        Line[x_] \[Rule] {Hue[ .6], Thickness[ .01], Line[x]}; \n
    vctng = Graphics3D[{vector3D[p, v1, Yellow,  .01], 
          vector3D[p, v2, Yellow,  .01]}]; \n
    nrml = Graphics3D[{vector3D[p, Cross[v1, v2], Magenta,  .01]}]; \n
    plntg = ParametricPlot3D[\[Gamma][a, b] + s*v1 + t*v2, 
        \ {s, \(- .5\),  .5}, {t, \(- .5\),  .5}, 
        DisplayFunction \[Rule] Identity]; \ \n
    esfera = ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]]}, {\[Phi], \(-\[Pi]\), 
          \[Pi]}, {\[Theta], 0, \[Pi]}, DisplayFunction \[Rule] Identity]; \n
    Show[esfera, curva1, curva2, plntg, vctng, nrml, 
      DisplayFunction \[Rule] $DisplayFunction, Boxed -> False, 
      Axes -> False, ViewPoint -> {0.174, \ \(-2.944\), \ 1.659}]; \n
    Print["\<Gr\[AAcute]ficas de la esfera S=\[Gamma]([0,2\[Pi]]\[Times][0,\
\[Pi]]);\nde las curvas \[Theta]\[Rule]\[Gamma](\[Theta],b) (en azul), \[Phi]\
\[Rule]\[Gamma](a,\[Phi]) (en rojo);\nde los vectores tangentes a dichas \
curvas en su punto de corte;\nde una parte del plano tangente en dicho punto\n\
y del vector normal en dicho punto\>"]; \n
    Clear[esfera, curva1, curva2, plntg, vctng, nrml]\)], "Input"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z)\)]],
  " es un campo escalar de tres variables, las superficies de \
ecuaci\[OAcute]n impl\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = c\)]],
  " o, lo que es igual ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) - c = 0\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " es una constante, se llaman ",
  StyleBox["superficies de nivel",
    FontWeight->"Bold"],
  " (cuando el campo se interpreta como un potencial se llaman ",
  StyleBox["superficies equipotenciales",
    FontWeight->"Bold"],
  "). De lo dicho en ",
  StyleBox["2)",
    FontWeight->"Bold"],
  ", se sigue que el vector gradiente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(x, y, z)\)\)]],
  " es ortogonal en todo punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\((x, y, z)\)\)\)]],
  " (en el que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(x, y, z)\) \[NotEqual] \ 0\)]],
  ") a la superficie de nivel que pasa por dicho punto. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Calcula las ecuaci\[OAcute]nes del plano tangente y de la recta normal a \
cada una de las siguientes superficies en el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " que se indica en cada caso.\na) ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(z\^2 - 2\ x\^2 - 2  y\^2 - 12 = 0\)\(,\)\)\)]],
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((1, \(-1\), 4)\)\(.\)\)\)]],
  "\nb) ",
  Cell[BoxData[
      \(TraditionalForm\`z - log(x\^2 + y\^2) = 0\)]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((1, 0, 0)\)\(.\)\)\)]],
  "\nc) ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^3 - 2\ x + \ 4  y\  + 3\ z\  + 1 = 
        0\)]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((3, 4, \(-3\))\)\(.\)\)\)]],
  "\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{"(", 
            RowBox[{\(u + v\), ",", 
              RowBox[{"3", " ", 
                FormBox[\(u\^2\),
                  "TraditionalForm"]}], ",", " ", \(u - v\)}], ")"}]}], 
        TraditionalForm]]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((2, 3, 0)\)\(.\)\)\)]],
  "\ne) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{\((u\  + v)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{"u", " ", "cos", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"v", " ", "sen", " ", "u", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", \t",
  Cell[BoxData[
      \(TraditionalForm\`P = \(\((1, 1, 0)\)\(.\)\)\)]]
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gradiente de un campo escalar", "Section"],

Cell[TextData[{
  "El gradiente de un campo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es el campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]f\)]],
  " cuyas componentes son las derivadas parciales de primer orden de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". El vector gradiente es \[UAcute]til para calcular derivadas de un campo \
escalar en una direcci\[OAcute]n dada. Te recuerdo que una direcci\[OAcute]n \
en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " es un vector de norma 1. Si ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es un campo escalar con derivadas parciales continuas, la derivada de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en un punto ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "en la direcci\[OAcute]n dada por el vector ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "viene dada por el producto escalar ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]\[Del]\(f(a)\) | u\[RightAngleBracket]\)]],
  ". Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(a)\) \[NotEqual] 0\)]],
  ", la direcci\[OAcute]n en la cual la derivada direccional de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "es m\[AAcute]xima, que indica la direcci\[OAcute]n en la cual el campo en \
",
  StyleBox["a ",
    FontSlant->"Italic"],
  "crece m\[AAcute]s r\[AAcute]pidamente, viene dada por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(a)\) / || \[Del]\(f(a)\) || \)]],
  ". Por tanto, ",
  StyleBox[
  "el vector gradiente en cada punto indica la direcci\[OAcute]n en la que el \
campo aumenta m\[AAcute]s r\[AAcute]pidamente en dicho punto",
    FontWeight->"Bold"],
  ". An\[AAcute]logamente, la direcci\[OAcute]n en la cual la derivada \
direccional de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "es m\[IAcute]nima, que indica la direcci\[OAcute]n en la cual el campo en \
",
  StyleBox["a ",
    FontSlant->"Italic"],
  "decrece m\[AAcute]s r\[AAcute]pidamente, viene dada por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Del]\(f(a)\)\) / || \[Del]\(f(a)\) || \)]],
  ". Si ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "y ",
  StyleBox["b ",
    FontSlant->"Italic"],
  "son puntos de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "la direcci\[OAcute]n del punto ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "hacia el punto ",
  StyleBox["b ",
    FontSlant->"Italic"],
  "viene dada por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((b - a)\) / || b - a || \)]],
  ".\nSabemos tambi\[EAcute]n que el vector gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es ortogonal a las curvas de nivel (las curvas dadas por una ecuaci\
\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) - c = 0\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " es una constante). Vamos a comprobar estas propiedades \
gr\[AAcute]ficamente. ",
  "La orden \
\"PlotGradientField[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones]\" produce un \
campo vectorial representando el vector gradiente de f[x,y] en los puntos de \
una ret\[IAcute]cula formada por 15x15=225 rectangulitos en que se divide el \
rect\[AAcute]ngulo [xmin,xmax]x[ymin,ymax]. "
}], "Text"],

Cell[BoxData[
    \(\(<< Graphics`PlotField`\ \)\)], "Input"],

Cell[BoxData[
    \(f[x_, y_] := 2 \((x + y)\) Cos[x]; \n
    crnv = ContourPlot[f[x, y], {x, \(-2\), 2}, {y, \(-2\), 2}, 
        DisplayFunction \[Rule] Identity]; \n
    gf = PlotGradientField[f[x, y], {x, \(-2\), 2}, {y, \(-2\), 2}, 
        ScaleFactor -> 1, DisplayFunction \[Rule] Identity]; \n
    Show[crnv, gf, DisplayFunction \[Rule] $DisplayFunction]; \n
    Clear[crnv, gf]\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Define un comando de la forma  gRad[func][punto] que calcule el vector \
gradiente de un campo escalar \"func\" en un punto \"punto\".\nDefine un \
comando de la forma derDir[func][punto,dir] que calcule la derivada \
direccional de un campo es calar \"func\" en el punto \"punto\" en la direcci\
\[OAcute]n \"dir\". \nCalcula las derivadas de las siguientes funciones en el \
punto y en la direcci\[OAcute]n que se indica en cada caso.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", " ", 
          FormBox[\(sen(\@\( .01 + x\^2 + y\^2\))\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, \(-2\))\)\)]],
  ", direcci\[OAcute]n hacia el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-2\), \(-1\))\)\)]],
  ".\nb)",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(f(x, y, z) = 
        x\^2 + 2  y\^2 + 3  z\^2 - 3\)\)\)]],
  ", punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, \(-2\), 3)\)\)]],
  ", direcci\[OAcute]n hacia el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((3, \(-2\), 1)\)\)]],
  ".\nRepresenta los campos de gradiente de las funciones anteriores en la \
regi\[OAcute]n que se indica en cada caso. Para ello carga el paquete gr\
\[AAcute]fico \"PlotField\" y usa el comando \"PlotGradientField[ ]\" con la \
opci\[OAcute]n \"Axes\[Rule]True\". Consulta la ayuda de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Debes explicar en cada caso, teniendo en cuenta c\[OAcute]mo es la funci\
\[OAcute]n correspondiente, por qu\[EAcute] el campo de gradientes tiene el \
aspecto que tiene. Para ello puede ser \[UAcute]til representar \
gr\[AAcute]ficamente las funciones.\na1) Campo de gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1\/\(1 + 2  x\^2 + 2  y\^2\)\)]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 
        1, \ \(-1\) \[LessEqual] y \[LessEqual] 1\)]],
  ".\nb1) Campo de gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2/4 + y\^2/9\)]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 
        1, \ \(-1\) \[LessEqual] y \[LessEqual] 1\)]],
  ".\nc1) Campo de gradiente de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 4 - \((x - 2)\)\^2 - \((y - 3)\)\^2\)]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`1.5 \[LessEqual] x \[LessEqual] 2.5, \ 
      2.5 \[LessEqual] y \[LessEqual] 3.5\)]],
  ".\nd1) Campo de gradiente de ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", " ", 
          FormBox[\(sen(\@\( .01 + x\^2 + y\^2\))\),
            "TraditionalForm"]}], TraditionalForm]]],
  " en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\) \[LessEqual] x \[LessEqual] 
        2, \ \(-2\) \[LessEqual] y \[LessEqual] 2\)]],
  ". Usa en este caso la opci\[OAcute]n \"ScaleFactor\[Rule]None\"."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Supongamos que la temperatura en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " del plano viene dada por la funci\[OAcute]n  "
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`T(x, y) = 
      100\/\(1 + \((x - 10.5)\)\^2 + 2 \((y - 8.5)\)\^2\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Un misil parte de un punto inicial ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " y sigue una trayectoria poligonal formada por segmentos de longitud fija, \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] > 0\)]],
  ", de manera que en cada v\[EAcute]rtice de la poligonal la \
direcci\[OAcute]n del misil es la de mayor aumento de la temperatura. Define \
una funci\[OAcute]n cuyas variables sean el punto inicial, la longitud de \
cada segmento (\[Delta]) y el n\[UAcute]mero de segmentos que forman la \
trayectoria. La salida de tu funci\[OAcute]n debe ser una gr\[AAcute]fica con \
la trayectoria seguida por el misil (que para \[Delta] peque\[NTilde]o \
parecer\[AAcute] una curva suave y no una poligonal). Esta gr\[AAcute]fica \
debe incluir el punto de salida en azul y el punto m\[AAcute]s caliente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((10.5, 8.5)\)\(\ \)\)\)]],
  " en rojo con tama\[NTilde]o adecuado. Comprobar\[AAcute]s que la \
trayectoria se acerca (y quiz\[AAcute]s rodea) al punto m\[AAcute]s caliente. \
Experimenta con valores para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] = 0.05, 0.1, 0.5, 1\)]],
  " y elige en cada caso un n\[UAcute]mero de segmentos y un punto inicial \
apropiados."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
AutoGeneratedPackage->None,
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Gr\[AAcute]ficas 3D. Derivadas parciales.\nExtremos relativos y \
condicionados."], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Gr\[AAcute]ficas 3D. Derivadas parciales.\nExtremos relativos y \
condicionados."], "Header"]}},
Magnification->1,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[3165, 94, 85, 2, 50, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[3253, 98, 86, 2, 50, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 69905, 1938}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 68, 0, 55, "Title"],
Cell[1780, 51, 204, 4, 63, "Author"],

Cell[CellGroupData[{
Cell[2009, 59, 39, 0, 56, "Section"],
Cell[2051, 61, 713, 15, 246, "Text"],
Cell[2767, 78, 151, 3, 29, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2955, 86, 41, 0, 56, "Section"],
Cell[2999, 88, 163, 4, 130, "Input",
  InitializationCell->True],
Cell[3165, 94, 85, 2, 50, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[3253, 98, 86, 2, 50, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[3342, 102, 632, 12, 133, "Input",
  InitializationCell->True],
Cell[3977, 116, 855, 15, 190, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4869, 136, 73, 0, 36, "Section"],
Cell[4945, 138, 550, 14, 60, "Text"],
Cell[5498, 154, 482, 12, 29, "Text"],
Cell[5983, 168, 281, 9, 29, "Text"],
Cell[6267, 179, 221, 7, 29, "Text"],
Cell[6491, 188, 1190, 34, 98, "Text"],
Cell[7684, 224, 192, 4, 25, "Text"],
Cell[7879, 230, 248, 7, 29, "Text"],
Cell[8130, 239, 820, 29, 48, "Text"],
Cell[8953, 270, 124, 2, 25, "Text"],
Cell[9080, 274, 218, 5, 29, "Text"],
Cell[9301, 281, 98, 2, 49, "Theorem"],
Cell[9402, 285, 295, 5, 48, "Text"],
Cell[9700, 292, 415, 8, 155, "Input"],
Cell[10118, 302, 300, 6, 29, "Text"],
Cell[10421, 310, 48, 1, 50, "Input"],
Cell[10472, 313, 2006, 45, 222, "Text"],
Cell[12481, 360, 350, 7, 48, "Text"],
Cell[12834, 369, 306, 5, 90, "Input"],
Cell[13143, 376, 374, 10, 33, "Text"],
Cell[13520, 388, 233, 4, 54, "Input"],
Cell[13756, 394, 336, 9, 29, "Text"],
Cell[14095, 405, 241, 4, 54, "Input"],
Cell[14339, 411, 280, 5, 48, "Text"],
Cell[14622, 418, 782, 17, 137, "Input"],
Cell[15407, 437, 609, 9, 67, "Text"],
Cell[16019, 448, 266, 5, 70, "Input"],
Cell[16288, 455, 285, 7, 29, "Text"],
Cell[16576, 464, 182, 3, 54, "Input"],
Cell[16761, 469, 251, 4, 48, "Text"],
Cell[17015, 475, 186, 3, 54, "Input"],
Cell[17204, 480, 128, 3, 29, "Text"],
Cell[17335, 485, 123, 3, 49, "Theorem"],
Cell[17461, 490, 493, 8, 110, "Text"],
Cell[17957, 500, 207, 4, 50, "Input"],
Cell[18167, 506, 115, 3, 29, "Text"],
Cell[18285, 511, 198, 3, 50, "Input"],
Cell[18486, 516, 404, 8, 48, "Text"],
Cell[18893, 526, 166, 2, 54, "Input"],
Cell[19062, 530, 482, 9, 48, "Text"],
Cell[19547, 541, 174, 3, 50, "Input"],
Cell[19724, 546, 94, 1, 29, "Text"],
Cell[19821, 549, 136, 2, 50, "Input"],
Cell[19960, 553, 61, 0, 49, "Theorem"],
Cell[20024, 555, 1268, 21, 105, "Text"],
Cell[21295, 578, 572, 11, 151, "Input"],
Cell[21870, 591, 441, 8, 48, "Text"],
Cell[22314, 601, 101, 1, 29, "Text"],
Cell[22418, 604, 335, 5, 48, "Text"],
Cell[22756, 611, 141, 3, 51, "Input"],
Cell[22900, 616, 143, 3, 29, "Text"],
Cell[23046, 621, 57, 1, 50, "Input"],
Cell[23106, 624, 532, 8, 67, "Text"],
Cell[23641, 634, 275, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[23941, 642, 31, 0, 39, "Exercise"],
Cell[23975, 644, 1738, 41, 175, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25750, 690, 31, 0, 39, "Exercise"],
Cell[25784, 692, 971, 18, 103, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26792, 715, 31, 0, 39, "Exercise"],
Cell[26826, 717, 437, 10, 48, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27312, 733, 38, 0, 56, "Section"],
Cell[27353, 735, 688, 18, 48, "Text"],
Cell[28044, 755, 119, 3, 50, "Input"],
Cell[28166, 760, 397, 10, 48, "Text"],
Cell[28566, 772, 250, 4, 91, "Input"],
Cell[28819, 778, 184, 4, 29, "Text"],
Cell[29006, 784, 113, 2, 90, "Input"],
Cell[29122, 788, 1163, 30, 86, "Text"],
Cell[30288, 820, 101, 2, 90, "Input"],
Cell[30392, 824, 287, 5, 48, "Text"],
Cell[30682, 831, 153, 4, 110, "Input"],
Cell[30838, 837, 223, 4, 29, "Text"],
Cell[31064, 843, 331, 5, 90, "Input"],
Cell[31398, 850, 100, 2, 90, "Input"],
Cell[31501, 854, 201, 6, 29, "Text"],
Cell[31705, 862, 153, 3, 50, "Input"],
Cell[31861, 867, 88, 2, 29, "Text"],
Cell[31952, 871, 61, 1, 50, "Input"],
Cell[32016, 874, 406, 10, 48, "Text"],
Cell[32425, 886, 76, 1, 29, "Text"],
Cell[32504, 889, 365, 7, 48, "Text"],
Cell[32872, 898, 245, 4, 90, "Input"],

Cell[CellGroupData[{
Cell[33142, 906, 31, 0, 39, "Exercise"],
Cell[33176, 908, 541, 16, 88, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33754, 929, 31, 0, 39, "Exercise"],
Cell[33788, 931, 430, 12, 37, "ExerciseText"],
Cell[34221, 945, 952, 28, 112, "ExerciseText"],
Cell[35176, 975, 161, 5, 43, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35386, 986, 63, 0, 56, "Section"],
Cell[35452, 988, 1535, 47, 98, "Text"],
Cell[36990, 1037, 321, 11, 29, "Text"],
Cell[37314, 1050, 539, 14, 25, "Text"],
Cell[37856, 1066, 914, 28, 48, "Text"],
Cell[38773, 1096, 3721, 90, 41, "Text"],
Cell[42497, 1188, 3775, 92, 41, "Text"],
Cell[46275, 1282, 940, 28, 67, "Text"],
Cell[47218, 1312, 1375, 35, 41, "Text"],
Cell[48596, 1349, 3304, 101, 124, "Text"],
Cell[51903, 1452, 194, 3, 25, "Text"],
Cell[52100, 1457, 2635, 69, 132, "Text"],
Cell[54738, 1528, 69, 0, 29, "Text"],
Cell[54810, 1530, 1925, 31, 370, "Input"],
Cell[56738, 1563, 1073, 33, 67, "Text"],

Cell[CellGroupData[{
Cell[57836, 1600, 31, 0, 39, "Exercise"],
Cell[57870, 1602, 1775, 54, 164, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59694, 1662, 48, 0, 56, "Section"],
Cell[59745, 1664, 3456, 103, 193, "Text"],
Cell[63204, 1769, 61, 1, 50, "Input"],
Cell[63268, 1772, 399, 7, 130, "Input"],

Cell[CellGroupData[{
Cell[63692, 1783, 31, 0, 39, "Exercise"],
Cell[63726, 1785, 3019, 69, 321, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66782, 1859, 31, 0, 39, "Exercise"],
Cell[66816, 1861, 193, 5, 29, "ExerciseText"],
Cell[67012, 1868, 142, 3, 45, "Text"],
Cell[67157, 1873, 1292, 25, 105, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

